/**
 * 
 */
package simulator;

import service.ServiceFactory;
import service.SimpleTransition;
import service.SimpleState;
import service.TransitionSystem;
import simulator.plus.SimulationPlusImpl;

/**
 * @author daniele
 *
 */
public interface SimulationFactory {

	/**
	 * generates a new simulation given the transition system of the target service and the ones of the available services
	 * @param target the transition system of the target service
	 * @param availableServices the transition systems of the available services
	 * @return a new Simulation
	 * @throws Exception the simulation cannot be created with the given available services
	 */
	public SimulationPlusImpl createSimulationPlus(TransitionSystem<SimpleState, SimpleTransition> target,
			TransitionSystem<SimpleState, SimpleTransition>[] availableServices,ServiceFactory serviceFactory)
			throws Exception;
	public Simulation createSimulationStandard(TransitionSystem<SimpleState, SimpleTransition> target,
			TransitionSystem<SimpleState, SimpleTransition>[] availableServices)
			throws Exception;
}
